﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Security.Cryptography.X509Certificates;
using Kz.GammaTech.Crypto;
using Kz.GammaTech.Signers;
using System.IO;

namespace ProfilesCertificates
{
    class Program
    {
        static void Main(string[] args)
        {
            X509Store store = new X509Store("MY");
            X509Certificate2 cert = null;
            try
            {
                store.Open(OpenFlags.ReadOnly);
                X509Certificate2Collection certCollection = store.Certificates;
                X509Certificate2Collection signingCert = certCollection.Find(X509FindType.FindBySubjectName, "ӘІҢҒҮҰҚӨ", false);
                cert = signingCert[0];
            }
            finally
            {
                store.Close();
            }

            AsymmetricCipherKeyPair pair = new AsymmetricCipherKeyPair(cert);
            GostSigner s = new GostSigner();
            s.privatekey = pair.Private;
            byte[] res = s.SignData(System.Text.Encoding.ASCII.GetBytes("adasda"));

            GostSigner v = new GostSigner();
            v.publickey = pair.Public;
            bool r = v.VerifyData(System.Text.Encoding.ASCII.GetBytes("adasda"), res);

            TumarProfile profile1 = new TumarProfile("profile://12345", "123");
            TumarProfile profile_path = new TumarProfile(@"C:\1\temp_key.pfx", "1");
            FileStream ff = new FileStream("c:\\1\\example.pfx", FileMode.Open);
            byte[] blob = new byte[ff.Length];
            ff.Read(blob, 0, blob.Length);
            ff.Close();
            TumarProfile profile_blob = new TumarProfile(blob,true, "1");
     
            s.privatekey = profile1.keys[0].Private;
            byte[] res1 = s.SignData(System.Text.Encoding.ASCII.GetBytes("adasda"));

            s.privatekey = profile_path.keys[0].Private;
            byte[] res2 = s.SignData(System.Text.Encoding.ASCII.GetBytes("adasda"));

            s.privatekey = profile_blob.keys[0].Private;
            byte[] res3 = s.SignData(System.Text.Encoding.ASCII.GetBytes("adasda"));
			
			profile1.FreeProfile();
			profile_path.FreeProfile();
			profile_blob.FreeProfile();

        }
    }
}
